<?php
   $file = "books.xml";
   $currentTag = "";
   $titleValue = "";        // Value of the title element 
   $authorsValue = array(); // Array of the values of the author elements 
   $isbnValue = "";         // Value of the isbn element
   $priceValue = "";        // Value of the price element
   $currencyValue = "";     // Value of the book element's currency attribute
   $descriptionValue = "";  // Value of the description entity reference
   $authorCount=0;          // Variable used to populate the $authorsValue array
   $books = array();           // Contains the details of books.

function startElement($parser, $name, $attr) {
   global $currentTag, $currencyValue;
   $currentTag = $name;
   if (strcmp($name, "price") == 0)
      $currencyValue = $attr["currency"];
   }
   function endElement($parser, $name) {
      global $titleValue, $authorsValue, $isbnValue, $priceValue,
             $currencyValue, $books, $authorCount, $descriptionValue;
      if (strcmp($name, "book") == 0) {
         $books[] = array("title"=>$titleValue, 
                          "authors" =>$authorsValue, 
                          "isbn" => $isbnValue, 
                          "price" =>$priceValue,
                          "currency" =>$currencyValue,
                          "description" =>$descriptionValue) ;
         $titleValue = "";
         $authorsValue = array();
         $isbnValue = "";
         $priceValue = "";
         $authorCount=0;
         $currencyValue="";
         $descriptionValue = "";
      } elseif (strcmp($name, "author")== 0) {
         $authorCount++;
         $authorsValue[$authorCount] = "";
      }
   }
   function characterData($parser, $data) {
      global $titleValue, $authorsValue, $isbnValue,$priceValue, 
             $currentTag, $authorCount;
      if (strcmp($currentTag, "title") == 0) {
         $titleValue .= $data;
      } elseif (strcmp($currentTag, "author") == 0) {
         $authorsValue[$authorCount] .= $data;
      } elseif (strcmp($currentTag, "isbn") == 0) {
         $isbnValue .= $data;
      } elseif (strcmp($currentTag, "price") == 0) {
         $priceValue .= $data;
      }
   }
   function externalEntityHandler($parser, $entityName, $base, 
                                  $systemId, $publicId) {
      global $descriptionValue;
      if (!systemId)
         return false;
      $descriptionValue = $systemId;
      return true;
   }
   function readBookInfo() {
      global $file, $books;
      $xml_parser = xml_parser_create();
      xml_set_element_handler($xml_parser, "startElement", "endElement");
      xml_set_character_data_handler($xml_parser,"characterData");
      xml_set_external_entity_ref_handler($xml_parser, "externalEntityHandler");
      xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false);
   if (!($fp = fopen($file, "r"))) {
      die("Could not open $file for reading") ;
   }
   while (($data = fread($fp, 4096))) {
      if (!xml_parse($xml_parser, $data, feof($fp))){
         die(sprintf("XML error at line %d column %d", 
                      xml_get_current_line_number($xml_parser), 
                      xml_get_current_column_number($xml_parser)));
      }
   }
      xml_parser_free($xml_parser);
      return $books;
   }
   function printBookInfo($titleValue, $authorsValue, $isbnValue, $priceValue, 
                          $currencyValue) {
      print "<TR>";
      print "<TD><A HREF=\"display_description.php?isbn=$isbnValue\">
           $titleValue</A></TD>";
      print "<TD>";
      for($j=0; $j<count($authorsValue)-1; $j++) {
         if ($j !=0)
            print ",";
         print " $authorsValue[$j] ";
      }
      print "</TD>";
      print "<TD>$isbnValue</TD>";
      print "<TD>$priceValue $currencyValue</TD>";
      print "</TR>";
   }
   function searchBookByISBN($books, $isbn) {
      for($i = 0; $i < count($books); $i++) {
         if (strcmp(trim($books[$i]["isbn"]), trim($isbn)) == 0) {
            return $books[$i];
         }
      }
      return null;
   }
?>

